<?php

/*================================================================================================
IAK main configuration. SQUID3 + ICAP + SquidClamav + CLAMAV
--------------------------------------------------------------------------------------------------
6.0
    2014-05-09
        Only SQUID3 supported
    2014-05-29
        HAVP is substituted for ICAP + SquidClamav 6.11
    2014-04-30
        maximum_object_size (KB -> MB)
    2014-05-31
        access_log /var/log/.... -> access_log daemon:/var/log/..... (for Ubuntu 14.04)
        icp_access allow all -> icp_access deny all
        Added access logs for useragents and referrals (only for Ubuntu 14.04)
        manager acl -> manager2. Duplicated?
5.2
    2014-01-11
        Enable / NO enable capability added
    2014-02-06
        Messages language selection BUG. 'break' statment added.
5.1
    2013-04-23
        SQUID3 capability added
================================================================================================*/

include("lhiak_defines.php");
require_once("lhiak_functions.php");
include("lhiak_getconfparam.php");
require_once ("lhiak_version.inc");



/*================================================================================================
 ------- Make Configuration Files Backup -------
================================================================================================*/
if (!file_exists($SQUID3_CONF_FILE_BAK)) {
    exec("$CP $SQUID3_CONF_FILE $SQUID3_CONF_FILE_BAK");
}

//if (!file_exists($SQUID3_ACCESS_DENIED_BAK)) {
//    exec("$CP $SQUID3_ACCESS_DENIED $SQUID3_ACCESS_DENIED_BAK");
//}

if ($options['iak-antivir-enable'] == "1") {
//    if (!file_exists($HAVP_CONF_FILE_BAK)) {
//        exec("$CP $HAVP_CONF_FILE $HAVP_CONF_FILE_BAK");
//    }
    if (!file_exists($ICAP_CONF_FILE_BAK)) {
        exec("$CP $ICAP_CONF_FILE $ICAP_CONF_FILE_BAK");
    }
    if (!file_exists($SQUIDCLAMAV_CONF_FILE_BAK)) {
        exec("$CP $SQUIDCLAMAV_CONF_FILE $SQUIDCLAMAV_CONF_FILE_BAK");
    }
    if (!file_exists($CLAMAV_CONF_FILE_BAK)) {
        exec("$CP $CLAMAV_CONF_FILE $CLAMAV_CONF_FILE_BAK");
        exec("$CP $CLAMAV_CONF_FILE_SKEL $CLAMAV_CONF_FILE");
    }
}


if ($options['iak-antivir-enable'] == "1") {
/*===============================================================================================
 ------- Configure c-icap -------
================================================================================================*/
    // Set ServerAadmin
    exec("$SED -i s/ServerAdmin.*/'ServerAdmin\ '$syst_admin_email/ $ICAP_CONF_FILE");
    // Set ServerName
    exec("$SED -i s/ServerName.*/'ServerName\ '$iak_webserver/ $ICAP_CONF_FILE");
    // Set MaxMemObject
    exec("$SED -i s/MaxMemObject.*/'MaxMemObject\ 131072'/ $ICAP_CONF_FILE"); // 131072
    // Set ModulesDir
//    exec();
    // Set ServicesDir
//    exec();
    // Set TemplateDir
//    exec();
    // Set TemplateDefaultLanguage
//    exec();
    // Set LogFormat
//    exec();
    // Set ServerLog
//    exec();
    // Set AccessLog
//    exec();

// / ???    exec(/etc/c-icap/c-icap.conf);

    // change c-icap's user and group
    exec("$SED -i s/User.*/'User proxy'/ $ICAP_CONF_FILE");
    exec("$SED -i s/Group.*/'Group proxy'/ $ICAP_CONF_FILE");
    // change c-icap's log's owner
    exec("$CHOWN -R proxy /var/log/c-icap");

    // Enable c-icap in /etc/default/c-icap
    exec("$SED -i s/START=no/START=yes/ /etc/default/c-icap");



/*===============================================================================================
 ------- Configure SquidClamav -------
================================================================================================*/
    // redirect to ??????????????
    exec("$SED -i s/redirect.*/'redirect\ $iak_web_server/iak/????'/ $SQUIDCLAMAV_CONF_FILE");

    //clamd_local -> #clamd_local
//???    exec("$SED -i s/clamd_local.*/'redirect\ $iak_web_server/iak/????'/ $SQUIDCLAMAV_CONF_FILE");
// clamd_ip -> 127.0.0.1
//clamd_port 3310
// logredir 1
// dnslookup 0

// scan text files?

// scan videos ??

//( scan flash???

    //restart c-icap ???

}
else{
    // Disable c-icap in /etc/default/c-icap
    exec("$SED -i s/START=yes/START=no/ /etc/default/c-icap");

    // stop c-icap

    // stop clamav ???
}




if (1 == 0){
/*===============================================================================================
 ------- Configure HAVP -------
================================================================================================*/

    // Copy original file to make changes
    if (file_exists ($HAVP_CONF_FILE_BAK)) {
        exec("$CP $HAVP_CONF_FILE_BAK $HAVP_CONF_FILE");
    }

    // Make exec directory, copy binary and set permissions
//#    exec("$MKDIR $HAVP_EXEC_DIR");
    exec("$CP $HAVP_EXEC_FILE_SRC $HAVP_EXEC_FILE");
//#    exec("$CHMOD 0755 $HAVP_EXEC_DIR");
    exec("$CHMOD 0755 $HAVP_EXEC_FILE");
    exec("$LN $HAVP_ORIG_CONG_DIR $HACO_CONF_DIR");

    // Copy and personalize error messages
    exec("$MKDIR /etc/havp/templates/eu");
    exec("$MKDIR /etc/havp/templates/es");
    exec("$CP -f /var/www/lhpaiak/havp-eu/* /etc/havp/templates/eu/");
    exec("$CP -f /var/www/lhpaiak/havp-es/* /etc/havp/templates/es/");
    // Administrator's email
    exec("$SED -i s/PROXYADMEPOSTA/$iak_admin_email/ /etc/havp/templates/eu/*");
    exec("$SED -i s/PROXYADMEPOSTA/$iak_admin_email/ /etc/havp/templates/es/*");
    // Web server's name
    exec("$SED -i s/PROXYWEBZERB/$iak_webserver/ /etc/havp/templates/eu/*");
    exec("$SED -i s/PROXYWEBZERB/$iak_webserver/ /etc/havp/templates/es/*");
    // Logrotate
    if (!file_exists($HAVP_LOGROTATE_FILE)) {
        exec("$CP $HAVP_LOGROTATE_FILE_SKEL $HAVP_LOGROTATE_FILE");
    }

    // Max file size to scan
    exec("$SED -i s/[#\ ]*MAXSCANSIZE.*/'MAXSCANSIZE\ '$iak_clamav_maxfilesize/ $HAVP_CONF_FILE");
    // Min number of instances (35)
    exec("$SED -i s/[#\ ]*SERVERNUMBER.*/'SERVERNUMBER\ 35'/ $HAVP_CONF_FILE");
    // ClamAV database directory
    exec("$SED -i s/[#\ ]*CLAMDBDIR.*/'CLAMDBDIR\ \/var\/lib\/clamav'/ $HAVP_CONF_FILE");
    // Enable ClamAV
    exec("$SED -i s/ENABLECLAMLIB.*/'ENABLECLAMLIB true'/ $HAVP_CONF_FILE");
    // TCP port to listen for connections
    // Default port is 8080.  In other case, set port in configuration file
    if ($iak_antivir_port != "8080") {
        exec("$SED -i s/[#\ ]*PORT.*/PORT\ $iak_antivir_port/ $HAVP_CONF_FILE");
    }

    // Messages language
    exec("$SED -i s/[#\ ]*TEMPLATEPATH.*/'TEMPLATEPATH \/etc\/havp\/templates\/'$iak_mezuhizk/ $HAVP_CONF_FILE");
    // Location for black lists and white lists
    exec("$SED -i s/[#\ ]*WHITELIST\ .*/'WHITELIST\ \/etc\/havp\/whitelist'/ $HAVP_CONF_FILE");
    exec("$SED -i s/[#\ ]*BLACKLIST\ .*/'BLACKLIST\ \/etc\/havp\/blacklist'/ $HAVP_CONF_FILE");
    // Enable proxy
    exec("$SED -i s/^REMOVETHISLINE.*/'#\ REMOVETHISLINE\ deleteme'/ $HAVP_CONF_FILE");

    exec("$HAVP_RESTART");
}

//else
//    if (file_exists('/etc/init.d/havp'))
//        exec("$HAVP_STOP");


/*===============================================================================================
 ------- Configure SQUID3 -------
================================================================================================*/
log_string_tologfile(">>> Start creating SQUID3 configuration file.");

exec("$ECHO '#======= LHIAK ' $LHIAK_VERSION ' =======' > $SQUID3_CONF_FILE");

exec("$ECHO '\n# ---------- Cache Parameters ----------' >> $SQUID3_CONF_FILE");
//cache_mem ... MB OK
exec("$ECHO 'cache_mem '$iak_proxy_maxmem' MB' >> $SQUID3_CONF_FILE");
//maximum_object_size .... MB OK
exec("$ECHO 'maximum_object_size '$iak_proxy_obj_maxsize' MB' >> $SQUID3_CONF_FILE");
//maximum_object_size_in_memory ..... KB OK
exec("$ECHO 'maximum_object_size_in_memory '$iak_proxy_obj_maxsize_mem' KB' >> $SQUID3_CONF_FILE");

// ------ This parameters cannot be changed. Their values are hardwired (at this time).
//ipcache_size .... OK
exec("$ECHO 'ipcache_size '$iak_proxy_ip_cache_size >> $SQUID3_CONF_FILE");
//fqdncache_size .... OK
exec("$ECHO 'fqdncache_size '$iak_proxy_fqdn_cache_size >> $SQUID3_CONF_FILE");

//icp_port 0
exec("$ECHO 'icp_port 0' >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# ---------- Cache Refresh Patterns ----------' >> $SQUID3_CONF_FILE");
//refresh_pattern ^ftp:       1440    20% 10080
exec("$ECHO 'refresh_pattern ^ftp:       1440    20% 10080' >> $SQUID3_CONF_FILE");
//refresh_pattern ^gopher:    1440    0%  1440
exec("$ECHO 'refresh_pattern ^gopher:    1440    0%  1440' >> $SQUID3_CONF_FILE");
//refresh_pattern .       0   20% 4320
exec("$ECHO 'refresh_pattern .       0   20% 4320' >> $SQUID3_CONF_FILE");

//refresh_pattern         \.gif$          10080   100%  43200 refresh-ims
exec("$ECHO 'refresh_pattern -i         \.gif$          10080   100%  43200 refresh-ims' >> $SQUID3_CONF_FILE");
//refresh_pattern         \.jpg$          10080  100%  43200 refresh-ims
exec("$ECHO 'refresh_pattern -i         \.jpg$          10080  100%  43200 refresh-ims' >> $SQUID3_CONF_FILE");
//refresh_pattern         \.jpeg$          10080  100%  43200 refresh-ims
exec("$ECHO 'refresh_pattern -i         \.jpeg$          10080  100%  43200 refresh-ims' >> $SQUID3_CONF_FILE");
//refresh_pattern         \.png$          10080  100%  43200 refresh-ims
exec("$ECHO 'refresh_pattern -i         \.png$          10080  100%  43200 refresh-ims' >> $SQUID3_CONF_FILE");

//refresh_pattern         \.mpg$          10080  100%  43200 refresh-ims
exec("$ECHO 'refresh_pattern -i         \.mpg$          10080  100%  43200 refresh-ims' >> $SQUID3_CONF_FILE");
//refresh_pattern         \.mpeg$          10080  100%  43200 refresh-ims
exec("$ECHO 'refresh_pattern -i         \.mpeg$          10080  100%  43200 refresh-ims' >> $SQUID3_CONF_FILE");

// Flash aggresive caching
//refresh_pattern -i         \.flv$          10080  90% 999999 ignore-no-cache override-expire ignore-private
exec("$ECHO 'refresh_pattern -i         \.flv$          10080  90%  999999 ignore-no-cache override-expire ignore-private' >> $SQUID3_CONF_FILE");

//refresh_pattern         \.css$          10080  100%  43200 override-lastmod refresh-ims
exec("$ECHO 'refresh_pattern -i         \.css$          10080  100%  43200 override-lastmod refresh-ims' >> $SQUID3_CONF_FILE");
//refresh_pattern         \.js$          10080  100%  43200 override-lastmod refresh-ims
exec("$ECHO 'refresh_pattern -i         \.js$          10080  100%  43200 override-lastmod refresh-ims' >> $SQUID3_CONF_FILE");
//refresh_pattern         \.axd$          10080  100%  43200 override-lastmod refresh-ims
exec("$ECHO 'refresh_pattern -i         \.axd$          10080  100%  43200 override-lastmod refresh-ims' >> $SQUID3_CONF_FILE");
//refresh_pattern .               960     90%     43200
exec("$ECHO 'refresh_pattern .               960     90%     43200' >> $SQUID3_CONF_FILE");
// ------ END of FIXED parameters

exec("$ECHO '\n# ---------- Administrative Data ----------' >> $SQUID3_CONF_FILE");
// ftp_user anonymous@NIRE-ESKOLA.NET OK
exec("$ECHO 'ftp_user '$iak_proxy_ftp_user_email >> $SQUID3_CONF_FILE");
// cache_mgr sare-admin@NIRE-ESKOLA.NET OK
exec("$ECHO 'cache_mgr '$syst_admin_email >> $SQUID3_CONF_FILE");
// visible_hostname 
 exec("$ECHO 'visible_hostname '$iak_webserver >> $SQUID3_CONF_FILE");

// Squid mssages language
switch ($iak_messages_lang){
    case "eu":
        $squid_error_lang = "Basque";
        break;
    case "es":
        $squid_error_lang = "Spanish";
        break;
    case "en":
        $squid_error_lang = "English";
        break;
    default :
        $squid_error_lang = "Basque";
}
exec("$ECHO '\n# ---------- Error Messages Language ----------' >> $SQUID3_CONF_FILE");
//    exec("$ECHO 'error_directory /usr/share/squid3/errors/'$squid_error_lang >> $SQUID3_CONF_FILE");
exec("$ECHO 'error_directory '$SQUID3_ERROR_PAGES_DIR_EXEC'/'$squid_error_lang >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# ---------- LOG System ----------' >> $SQUID3_CONF_FILE");
// cache_log /var/log/squid/cache.log
exec("$ECHO 'cache_log '$SQUID3_LOG_DIR'/cache.log' >> $SQUID3_CONF_FILE");
if ($DISTRO == "TRUSTY") {
    // access_log daemon:/var/log/squid/access.log squid
    exec("$ECHO 'access_log daemon:'$SQUID3_LOG_DIR'/access.log squid' >> $SQUID3_CONF_FILE");
    // access_log daemon:/var/log/squid/useragent.log useragent
    exec("$ECHO 'access_log daemon:'$SQUID3_LOG_DIR'/useragent.log useragent' >> $SQUID3_CONF_FILE");
    // access_log daemon:/var/log/squid/referrals.log referrer
    exec("$ECHO '#access_log daemon:'$SQUID3_LOG_DIR'/referrals.log referrer' >> $SQUID3_CONF_FILE");
}
else{
    // access_log daemon:/var/log/squid/access.log squid
    exec("$ECHO 'access_log '$SQUID3_LOG_DIR'/access.log squid' >> $SQUID3_CONF_FILE");
}
// debug_options ALL,1 33,1 28,1 ????
exec("$ECHO '# debug_options ALL,1 33,1 28,1' >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# ---------- SQUID Listening Address:Ports ----------' >> $SQUID3_CONF_FILE");
// http_port 172.x.y.z:3128  OK
if ($iak_ip1 != "") { exec("$ECHO 'http_port '$iak_ip1':'$iak_port >> $SQUID3_CONF_FILE"); }
if ($iak_ip2 != "") { exec("$ECHO 'http_port '$iak_ip2':'$iak_port >> $SQUID3_CONF_FILE"); }
if ($iak_ip3 != "") { exec("$ECHO 'http_port '$iak_ip3':'$iak_port >> $SQUID3_CONF_FILE"); }
if ($iak_ip4 != "") { exec("$ECHO 'http_port '$iak_ip4':'$iak_port >> $SQUID3_CONF_FILE"); }
if ($iak_ip5 != "") { exec("$ECHO 'http_port '$iak_ip5':'$iak_port >> $SQUID3_CONF_FILE"); }
if ($iak_ip6 != "") { exec("$ECHO 'http_port '$iak_ip6':'$iak_port >> $SQUID3_CONF_FILE"); }
if ($iak_ip7 != "") { exec("$ECHO 'http_port '$iak_ip7':'$iak_port >> $SQUID3_CONF_FILE"); }
if ($iak_ip8 != "") { exec("$ECHO 'http_port '$iak_ip8':'$iak_port >> $SQUID3_CONF_FILE"); }
// http_port 127.0.0.1:3128  OK --- localhost!!! ---
exec("$ECHO 'http_port 127.0.0.1:3128' >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# ---------- Secure Ports and ... ----------' >> $SQUID3_CONF_FILE");
// acl SSL_ports port 443 563 873 # https, snews, rsync
exec("$ECHO 'acl SSL_ports port 443 563 873 # https snews rsync' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 80      # http
exec("$ECHO 'acl Safe_ports port 80      # http' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 81      # http mail
exec("$ECHO 'acl Safe_ports port 81      # http mail' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 21      # ftp
exec("$ECHO 'acl Safe_ports port 21      # ftp' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 443 563 # https, snews
exec("$ECHO 'acl Safe_ports port 443 563 # https, snews' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 70      # gopher
exec("$ECHO 'acl Safe_ports port 70      # gopher' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 210     # wais
exec("$ECHO 'acl Safe_ports port 210     # wais' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 1025-65535  # unregistered ports
exec("$ECHO 'acl Safe_ports port 1025-65535  # unregistered ports' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 280     # http-mgmt
exec("$ECHO 'acl Safe_ports port 280     # http-mgmt' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 488     # gss-http
exec("$ECHO 'acl Safe_ports port 488     # gss-http' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 591     # filemaker
exec("$ECHO 'acl Safe_ports port 591     # filemaker' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 631     # cups
exec("$ECHO 'acl Safe_ports port 631     # cups' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 777     # multiling http
exec("$ECHO 'acl Safe_ports port 777     # multiling http' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 873     # rsync
exec("$ECHO 'acl Safe_ports port 873     # rsync' >> $SQUID3_CONF_FILE");
// acl Safe_ports port 901     # SWAT
exec("$ECHO 'acl Safe_ports port 901     # SWAT' >> $SQUID3_CONF_FILE");
// acl purge method PURGE
exec("$ECHO 'acl purge method PURGE' >> $SQUID3_CONF_FILE");
// acl CONNECT method CONNECT
exec("$ECHO 'acl CONNECT method CONNECT' >> $SQUID3_CONF_FILE");

// acl manager proto cache_object
exec("$ECHO 'acl manager2 proto cache_object' >> $SQUID3_CONF_FILE");
// acl all src all
//####    exec("$ECHO 'acl all src all' >> $SQUID3_CONF_FILE");
// acl localhost src 127.0.0.1/32
exec("$ECHO 'acl localhost src 127.0.0.1/32' >> $SQUID3_CONF_FILE");
// acl to_localhost dst 127.0.0.0/8
exec("$ECHO 'acl to_localhost dst 127.0.0.0/8' >> $SQUID3_CONF_FILE");

// ACLs IAK
exec("$ECHO '\n# ---------- Standard Access Permisions ----------' >> $SQUID3_CONF_FILE");
// http_access allow manager localhost
exec("$ECHO 'http_access allow manager2 localhost' >> $SQUID3_CONF_FILE");
// http_access deny manager
exec("$ECHO 'http_access deny manager2' >> $SQUID3_CONF_FILE");
// http_access allow purge localhost
exec("$ECHO 'http_access allow purge localhost' >> $SQUID3_CONF_FILE");
// http_access deny purge
exec("$ECHO 'http_access deny purge' >> $SQUID3_CONF_FILE");
// http_access deny !Safe_ports
exec("$ECHO 'http_access deny !Safe_ports' >> $SQUID3_CONF_FILE");
// http_access deny CONNECT !SSL_ports
exec("$ECHO 'http_access deny CONNECT !SSL_ports' >> $SQUID3_CONF_FILE");
// http_access allow network
//#	exec("$ECHO 'http_access allow network' >> $SQUID3_CONF_FILE");
// http_access allow localhost
exec("$ECHO 'http_access allow localhost' >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# ---------- Allow Proxy Addresses ----------' >> $SQUID3_CONF_FILE");
// Enable the proxy
if ($options['iak-ip1'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip1 >> $SQUID3_CONF_FILE");
if ($options['iak-ip2'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip2 >> $SQUID3_CONF_FILE");
if ($options['iak-ip3'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip3 >> $SQUID3_CONF_FILE");
if ($options['iak-ip4'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip4 >> $SQUID3_CONF_FILE");
if ($options['iak-ip5'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip5 >> $SQUID3_CONF_FILE");
if ($options['iak-ip6'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip6 >> $SQUID3_CONF_FILE");
if ($options['iak-ip7'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip7 >> $SQUID3_CONF_FILE");
if ($options['iak-ip8'] != "") exec("$ECHO 'acl ProxyAddresses dst '$iak_ip8 >> $SQUID3_CONF_FILE");
exec("$ECHO '\nhttp_access allow ProxyAddresses' >> $SQUID3_CONF_FILE");


if ($options['iak-antivir-enable'] == "1") {
    // ICAP Parameters
    exec("$ECHO '\n# ---------- ICAP Parameters ----------' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_enable on' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_send_client_ip on' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_send_client_username on' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_client_username_encode off' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_client_username_header X-Authenticated-User' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_preview_enable on' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_preview_size 1024' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_service service_req reqmod_precache bypass=1 icap://127.0.0.1:1344/squidclamav' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'adaptation_access service_req allow all' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'icap_service service_resp respmod_precache bypass=1 icap://127.0.0.1:1344/squidclamav' >> $SQUID3_CONF_FILE");
    exec("$ECHO 'adaptation_access service_resp allow all' >> $SQUID3_CONF_FILE");
}


exec("$ECHO '\n# ---------- No Caching Addresses ----------' >> $SQUID3_CONF_FILE");
// Address List to Not Cache
exec("$ECHO 'acl QUERY urlpath_regex cgi-bin \?' >> $SQUID3_CONF_FILE");
exec("$ECHO 'no_cache deny QUERY' >> $SQUID3_CONF_FILE");

exec("$ECHO include $IAK_NOCACHE_FILE_EXEC >> $SQUID3_CONF_FILE");


// Not Filtered Source Networks
exec("$ECHO '\n# ---------- Not Filtered Source Networks ----------' >> $SQUID3_CONF_FILE");
exec("$ECHO include $IAK_NFNETS_FILE_EXEC >> $SQUID3_CONF_FILE");


exec("$ECHO '\n# ---------- Internet Access Control ----------' >> $SQUID3_CONF_FILE");
// All Time Banned Addresses
exec("$ECHO '# All Time Banned Addresses' >> $SQUID3_CONF_FILE");
exec("$ECHO 'acl banneddoms url_regex \"/etc/squid3/iak.nodoms.conf\"' >> $SQUID3_CONF_FILE");
exec("$ECHO 'http_access deny banneddoms' >> $SQUID3_CONF_FILE");

// All Time Allowed Addresses
exec("$ECHO '\n# All Time Allowed Addresses' >> $SQUID3_CONF_FILE");
exec("$ECHO include $IAK_OKDOMAINS_FILE_EXEC >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# Allowed Browsers' >> $SQUID3_CONF_FILE");
exec("$ECHO 'include '$IAK_BROWSERS_FILE_EXEC >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# All Time Allowed Classrooms or IP Ranges' >> $SQUID3_CONF_FILE");
exec("$ECHO include $IAK_WHITEIPS_FILE_EXEC >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# All Time Allowed MAC Addresses' >> $SQUID3_CONF_FILE");
exec("$ECHO include $IAK_WHITEMACS_FILE_EXEC >> $SQUID3_CONF_FILE");

exec("$ECHO '\n# Controlled Classrooms Definitions' >> $SQUID3_CONF_FILE");
exec("$ECHO include $IAK_ROOMS_FILE_EXEC >> $SQUID3_CONF_FILE");

// Other Parameters
exec("$ECHO '\n# ---------- Other Parameters ----------' >> $SQUID3_CONF_FILE");
#    exec("$ECHO 'http_reply_access allow all' >> $SQUID3_CONF_FILE");
#    exec("$ECHO 'forwarded_for off' >> $SQUID3_CONF_FILE");
exec("$ECHO 'icp_access deny all' >> $SQUID3_CONF_FILE");
exec("$ECHO 'half_closed_clients off\n' >> $SQUID3_CONF_FILE");


// Make www-data group owner of configuration file (for read purpouses)
exec("$CHGRP www-data $SQUID3_CONF_FILE");
// Set Read Permisions
exec("$CHMOD 0640 $SQUID3_CONF_FILE");

// Copy to Execution-time place
exec("$CP $SQUID3_CONF_FILE $SQUID3_CONF_FILE_EXEC");

log_string_tologfile(">>> End creating SQUID3 configuration file.");

log_string_tologfile(">>> Start creating SQUID3 personalized ERROR files.");

// Backup Spanish Errors Directory
if (!file_exists("$SQUID3_ERROR_PAGES_DIR/es.orig")){ exec("$CP -r $SQUID3_ERROR_PAGES_DIR/es $SQUID3_ERROR_PAGES_DIR/es.orig"); }

// Create Basque Errors Directory and Link
if (!file_exists("$SQUID3_ERROR_PAGES_DIR_BASQUE")){ exec("$MKDIR $SQUID3_ERROR_PAGES_DIR_BASQUE"); }
if (!file_exists("$SQUID3_ERROR_PAGES_DIR_LINK_BASQUE")){ exec("$LN -s eu $SQUID3_ERROR_PAGES_DIR_LINK_BASQUE"); }


// Copy personalized error pages's skeleton
//    exec("$CP -f /var/www/lhiak/squid-basque/* /usr/share/squid/errors/Basque/");
//    exec("$CP -f /var/www/lhiak/squid-spanish/* /usr/share/squid/errors/Spanish/");

exec("$CP -f $SQUID3_ERROR_PAGES_SKEL_BASQUE/* $SQUID3_ERROR_PAGES_DIR_BASQUE/");
exec("$CP -f $SQUID3_ERROR_PAGES_SKEL_SPANISH/* $SQUID3_ERROR_PAGES_DIR_SPANISH/");

// Change Web server name and images in error pages
//    exec("$SED -i s/PROXYWEBZERB/$iak_webserver/ /usr/share/squid/errors/Basque/*");
//    exec("$SED -i s/PROXYWEBZERB/$iak_webserver/ /usr/share/squid/errors/Spanish/*");

exec("$SED -i s/PROXYWEBSERVER/$iak_webserver/ $SQUID3_ERROR_PAGES_DIR_BASQUE/*");
exec("$SED -i s/PROXYWEBSERVER/$iak_webserver/ $SQUID3_ERROR_PAGES_DIR_SPANISH/*");

exec("$SED -i s/HEADERIMAGE/$iak_web_head_img/ $SQUID3_ERROR_PAGES_DIR_BASQUE/*");
exec("$SED -i s/HEADERIMAGE/$iak_web_head_img/ $SQUID3_ERROR_PAGES_DIR_SPANISH/*");

exec("$SED -i s/FOOTERIMAGE/$iak_web_foot_img/ $SQUID3_ERROR_PAGES_DIR_BASQUE/*");
exec("$SED -i s/FOOTERIMAGE/$iak_web_foot_img/ $SQUID3_ERROR_PAGES_DIR_SPANISH/*");

// Web server must read this files
exec("$CHMOD +r $SQUID3_ERROR_PAGES_DIR_BASQUE/*");
exec("$CHMOD +r $SQUID3_ERROR_PAGES_DIR_SPANISH/*");

log_string_tologfile(">>> End creating SQUID3 personalized ERROR pages.");

//#	exec("$CHOWN proxy:proxy /var/spool/squid/swap.*"); # Zaharkitua ????


// Configuration Necessary Files (For the first time)
if(!file_exists($IAK_NOCACHE_FILE_EXEC))
    exec("$TOUCH $IAK_NOCACHE_FILE_EXEC");
if(!file_exists($IAK_NFNETS_FILE_EXEC))
    exec("$TOUCH $IAK_NFNETS_FILE_EXEC");
if(!file_exists($IAK_NODOMAINS_FILE_EXEC))
    exec("$TOUCH $IAK_NODOMAINS_FILE_EXEC");
if(!file_exists($IAK_OKDOMAINS_FILE_EXEC))
    exec("$TOUCH $IAK_OKDOMAINS_FILE_EXEC");
if(!file_exists($IAK_BROWSERS_FILE_EXEC))
    exec("$TOUCH $IAK_BROWSERS_FILE_EXEC");
if(!file_exists($IAK_WHITEIPS_FILE_EXEC))
    exec("$TOUCH $IAK_WHITEIPS_FILE_EXEC");
if(!file_exists($IAK_WHITEMACS_FILE_EXEC))
    exec("$TOUCH $IAK_WHITEMACS_FILE_EXEC");
if(!file_exists($IAK_ROOMS_FILE_EXEC))
    exec("$TOUCH $IAK_ROOMS_FILE_EXEC");



/*================================================================================================
 ------- Configure IAK (Web page color and error messages language are configured here) -------
================================================================================================*/
// Create web directory
exec("$MKDIR -p $IAK_WEB_FILE_EXEC_DIR");

// Copy IAK web page and images
//#	exec("$CP $IAK_WEB_FILE $IAK_WEB_FILE_EXEC");

// Copy images
exec("$CP iakimages/$iak_web_head_img $IAK_WEB_FILE_EXEC_DIR/");
exec("$CP iakimages/$iak_web_foot_img $IAK_WEB_FILE_EXEC_DIR/");
exec("$CP iakimages/favicon.ico $IAK_WEB_FILE_EXEC_DIR/");

// Create LOGs directory
exec("$MKDIR /var/log/iak");
// Change permisions in /var/log/iak directory to write logs
exec("$CHOWN www-data /var/log/iak");

// Copy logs rotate file
exec("$CP $IAK_LOGROTATE_FILE_SKEL $IAK_LOGROTATE_FILE");

// Erase old cron file
if (file_exists($IAK_CRONTAB_FILE_EXEC)) {
    exec("$RM $IAK_CRONTAB_FILE_EXEC");
}
if ($iak_autoclose_enable == "Bai") {
    if ($iak_autoclose_hour1 != "" && $iak_autoclose_minu1 != "") {
        exec("$ECHO $iak_autoclose_minu1 ' ' $iak_autoclose_hour1 ' * * * www-data php5 /var/www/iak/iakmanager.php default' > $IAK_CRONTAB_FILE");
    }
    if ($iak_autoclose_hour2 != "" && $iak_autoclose_minu2 != "") {
        exec("$ECHO $iakclose_minu2 ' ' $iak_autoclose_hour2 ' * * * www-data php5 /var/www/iak/iakmanager.php default' >> $IAK_CRONTAB_FILE");
    }
    exec("$CP $IAK_CRONTAB_FILE $IAK_CRONTAB_FILE_EXEC");
    exec("$CRON_RESTART");
}


/*================================================================================================
 ------- Restart Apache and SQUID3 -------
================================================================================================*/

$error = exec("$SQUID3_STATUS");
if ($error == "squid3 is running.")
    exec("$SQUID3_RELOAD");
else
    exec("$SQUID3_START");

exec("$APACHE_RELOAD");

log_string_tologfile("Error reload: " . $error);

?>
