<?php

/*================================================================================================
System configuration
--------------------------------------------------------------------------------------------------
6.0
2014-05-09
    Only SQUID3 supported
5.2
2014-01-11
    First version
================================================================================================*/

include("lhiak_defines.php");
require_once("lhiak_functions.php");
include("lhiak_getconfparam.php");
require_once ("lhiak_version.inc");


/*================================================================================================
 ------- Make Configuration Files Backup -------
================================================================================================*/

if (!file_exists($SQUID3_CONF_FILE_BAK)) {
    exec("$CP $SQUID3_CONF_FILE $SQUID3_CONF_FILE_BAK");
}

if (!file_exists($SQUID3_ACCESS_DENIED_BAK)) {
    exec("$CP $SQUID3_ACCESS_DENIED $SQUID3_ACCESS_DENIED_BAK");
}

if ($options['iak-antivir-enable'] == "Bai") {
    if (!file_exists($HAVP_CONF_FILE_BAK)) {
        exec("$CP $HAVP_CONF_FILE $HAVP_CONF_FILE_BAK");
    }
    if (!file_exists($CLAMAV_CONF_FILE_BAK)) {
        exec("$CP $CLAMAV_CONF_FILE $CLAMAV_CONF_FILE_BAK");
        exec("$CP $CLAMAV_CONF_FILE_SKEL $CLAMAV_CONF_FILE");
    }
}



/*================================================================================================
 ------- Set DNS Servers -------
================================================================================================*/
// Delete old resolv.conf file
if (file_exists("$RESOLV_CONF_FILE_EXEC"))
    exec("$RM $RESOLV_CONF_FILE_EXEC");

log_string_tologfile(">>Hor doa: " . $syst_dns2);

// Add search domain
exec("$ECHO 'search '$syst_domain > $RESOLV_CONF_FILE");

// Add first domain server
exec("$ECHO 'nameserver '$syst_dns1 >> $RESOLV_CONF_FILE");

// If no void, add second domain server
if ($syst_dns2 != ""){
    exec("$ECHO 'nameserver '$syst_dns2 >> $RESOLV_CONF_FILE");
}

exec("$CP $RESOLV_CONF_FILE $RESOLV_CONF_FILE_EXEC");



/*================================================================================================
 ------- Set NTP Servers and Place a script in cron.hourly to update system clock -------
================================================================================================*/
// If not "/etc/default/ntpdate" backup copy ... (first time)
if (!file_exists("/etc/default/ntpdate.orig")){
    exec("$CP /etc/default/ntpdate /etc/default/ntpdate.orig");
}

if ($options['syst-ntp1'] != "")
    $ntpsrvstr = $options['syst-ntp1'];
if ($options['syst-ntp2'] != "")
    $ntpsrvstr = $ntpsrvstr . " " . $options['syst-ntp2'];

if ($ntpsrvstr == "") $ntpsrvstr = "0.europe.pool.ntp.org";

log_string_tologfile(">>Hor doa: " . $ntpsrvstr);

// Change /etc/default/ntpdate configuration
exec("$SED -i s/NTPDATE_USE_NTP_CONF=yes/NTPDATE_USE_NTP_CONF=no/ /etc/default/ntpdate");
exec("$SED -i s/^NTPSERVERS=.*/'NTPSERVERS=\"$ntpsrvstr\"'/ /etc/default/ntpdate");

if(!file_exists("/etc/cron.hourly/ntpdate")){
    exec("$CP files/ntpdate /etc/cron.hourly/");
    exec("$CHMOD 755 /etc/cron.hourly/ntpdate");
}


/*================================================================================================
 ------- Set LHIAK Administrator's name and password -------
================================================================================================*/
// passapache2 -> /var/lib/apache2/lhiak.pass
$user = $options['syst-admin-user'];
$pass = $options['syst-admin-pass'];
exec("$APACHE_LHIAK_PASS_CRE $user $pass");


/*================================================================================================
 ------- Enable Apache2 LDAP authentication -------
================================================================================================*/
if (!file_exists("/etc/apache2/mods_enabled/ldap.load")){
    exec("$APACHE_ENMOD ldap");
    exec("$APACHE_ENMOD authnz_ldap");
}


/*================================================================================================
 ------- Set LHIAK configurator access configuration -------
================================================================================================*/
exec("$CP $LHIAK_APACHE_FILE_SKEL $LHIAK_APACHE_FILE_EXEC");
$email = $options['syst-admin-email'];
$server = $options['iak-webserver'];
$nets = $options['syst-admin-manage-allowed-nets'];
$admin = $options['syst-admin-user'];

log_string_tologfile(">>Manage nets: " . $nets);


exec("$SED -i s/WEBADMINEMAIL/$email/ $LHIAK_APACHE_FILE_EXEC");
exec("$SED -i s/WEBSERVERNAME/$server/ $LHIAK_APACHE_FILE_EXEC");
exec("$SED -i s/NETWORKS/'$nets'/ $LHIAK_APACHE_FILE_EXEC");
exec("$SED -i s/ADMINISTRATOR/$admin/ $LHIAK_APACHE_FILE_EXEC");


/*================================================================================================
 ------- Restart Apache2 and SQUID3 -------
================================================================================================*/ 

//if ($DISTRO == "PRECISE"){
    $error = exec("$SQUID3_RESTART");
//        log_string_tologfile("Squid restart error: " . $error);
//}
//else
//    exec("$SQUID_RELOAD");

exec("$APACHE_RELOAD");
?>
