<?php

/*================================================================================================
Main installation function
--------------------------------------------------------------------------------------------------
6.0
2014-05-09
    Only SQUID3 supported
2014-05-28
    Adapt to Debian's new apache2 config. directories ( /etc/apache2/conf.d => /etc/apache2/conf-enabled )
5.2
2014-01-11
    Include System module
5.1
2013-04-21
    Adapt to Ubuntu 12.04 / wheezy (squid3 -> squid)
================================================================================================*/

header("Location: {$_SERVER['HTTP_REFERER']}");


include("lhiak_defines.php");
require_once("lhiak_functions.php");
include("lhiak_getconfparam.php");

log_string_tologfile("Distro: " . $DISTRO);


/*================================================================================================
Get Web-page parameters
================================================================================================*/
//log_string_tologfile("Bigarrena antivir: " . $iak_gaitu_antivir);
include ("lhiak_getwebparam.php");

log_string_tologfile("Module: " . $module);


/*================================================================================================
Save all parameters
================================================================================================*/

if ($conf_file = fopen ($LHIAK_CONF_FILE, "w")){
    foreach ($options as $parametro => $balore) {
//		echo "$parametro = $balore"; echo '<br>';
        fwrite($conf_file, "$parametro = $balore\n");
    }
}
else {
    echo "Error opening configuration file."; echo "<br>";
    log_string_tologfile("Error opening configuration file.");
}


/*================================================================================================
Get parameters (some may be changed)
================================================================================================*/
include("lhiak_getconfparam.php");


/*================================================================================================
Adapting directory structure for diferent Linux distributions
================================================================================================*/
if ($DISTRO == "TRUSTY"){
    if (!file_exists("$APACHE_CONF_DIR"))
        exec("$LN $APACHE_new_CONF_DIR $APACHE_CONF_DIR");
}


/*================================================================================================
Configure classrooms
================================================================================================*/
if ($module == "iak_room_ip"){
    include ("lhiak_insiak_rooms.php");
}

if ($module == "iak_room_mac"){
    include ("lhiak_insiak_rooms.php");
}

// If is in DEMO mode, quit. Otherwise continue setting configuration
if ($LHIAK_ISADEMO == "Y"){
    lot_string_tologfile("Is in DEMO mode.");
    exit ;
}


/*================================================================================================
Configure System
================================================================================================*/
if ($module == "iak_syst"){
    include ("lhiak_insiak_syst.php");
}

/*================================================================================================
Configure HAVP, SQUID3 and IAK
================================================================================================*/
if ($module == "iak_iak") {
    include("lhiak_insiak_iak.php");
    include ("lhiak_insiak_rooms.php");
}

/*================================================================================================
Configure NOT filtered networks
================================================================================================*/
if ($module == "iak_nfnets"){
    include ("lhiak_insiak_nfnets.php");
}

/*================================================================================================
Configure All Time Allowed domains / addresses
================================================================================================*/
if ($module == "iak_okdom"){
    include ("lhiak_insiak_okdoms.php");
}

/*================================================================================================
Configure Banned Domains
================================================================================================*/
if ($module == "iak_nodo"){
    include ("lhiak_insiak_nodoms.php");
}

/*================================================================================================
Configure adresses to not cache
================================================================================================*/
if ($module == "iak_noca"){
    include ("lhiak_insiak_noca.php");
}

/*================================================================================================
Configure Allowed Brewsers
================================================================================================*/
if ($module == "iak_brow"){
    include ("lhiak_insiak_brow.php");
}

/*================================================================================================
Configure All Time Allowed IP ranges
================================================================================================*/
if ($module == "iak_wipr"){
    include ("lhiak_insiak_wipr.php");
}

/*================================================================================================
Configure All Time Allowed MAC Addresses
================================================================================================*/
if ($module == "iak_wmacs"){
    include ("lhiak_insiak_wmacs.php");
}

/*================================================================================================
Configure IAK Control Web Page Autentication
================================================================================================*/
if ($module == "iak_auth"){
    include ("lhiak_insiak_auth.php");
}

?>
